CONTAINER Mmaterial
{
	NAME Mmaterial;
	INCLUDE Obaselist;

	GROUP Obaselist
	{
		GROUP
		{
			LAYOUTGROUP; COLUMNS 2;
			GROUP
			{
				BOOL MATERIAL_USE_COLOR 				{ }
				BOOL MATERIAL_USE_DIFFUSION			{ }
				BOOL MATERIAL_USE_LUMINANCE			{ }
				BOOL MATERIAL_USE_TRANSPARENCY	{ }
				BOOL MATERIAL_USE_REFLECTION		{ }
				BOOL MATERIAL_USE_ENVIRONMENT		{ }
				BOOL MATERIAL_USE_FOG						{ }
			}
			GROUP
			{
				BOOL MATERIAL_USE_BUMP					{ }
				BOOL MATERIAL_USE_ALPHA					{ }
				BOOL MATERIAL_USE_SPECULAR			{ }
				BOOL MATERIAL_USE_SPECULARCOLOR	{ }
				BOOL MATERIAL_USE_GLOW					{ }
				BOOL MATERIAL_USE_DISPLACEMENT	{ }
			}
		}
		LONG MATERIAL_PREVIEWSIZE
		{
			CYCLE
			{
				MATERIAL_PREVIEWSIZE_DEF;
				MATERIAL_PREVIEWSIZE_64;
				MATERIAL_PREVIEWSIZE_128;
				MATERIAL_PREVIEWSIZE_256;
				MATERIAL_PREVIEWSIZE_512;
				MATERIAL_PREVIEWSIZE_1024;
				MATERIAL_PREVIEWSIZE_2048;
			}
		}
	}

	GROUP ID_MATERIALGROUP_COLOR
	{
		DEFAULT 1;
		COLOR	MATERIAL_COLOR_COLOR { OPEN; }
		REAL 	MATERIAL_COLOR_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		SEPARATOR { }
		TEXGROUP MATERIAL_COLOR_TEXGROUP { }
		LONG MATERIAL_COLOR_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_COLOR_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
	}

	GROUP ID_MATERIALGROUP_DIFFUSION
	{
		REAL  MATERIAL_DIFFUSION_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		BOOL  MATERIAL_DIFFUSION_AFFECT_LUMINANCE { }
		BOOL  MATERIAL_DIFFUSION_AFFECT_SPECULAR { }
		BOOL  MATERIAL_DIFFUSION_AFFECT_REFLECTION { }
		SEPARATOR { }
		TEXGROUP MATERIAL_DIFFUSION_TEXGROUP { }
		LONG MATERIAL_DIFFUSION_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_DIFFUSION_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
	}

	GROUP ID_MATERIALGROUP_LUMINANCE
	{
		COLOR	MATERIAL_LUMINANCE_COLOR { OPEN; }
		REAL 	MATERIAL_LUMINANCE_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		SEPARATOR { }
		TEXGROUP MATERIAL_LUMINANCE_TEXGROUP { }
		LONG MATERIAL_LUMINANCE_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_LUMINANCE_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
	}

	GROUP ID_MATERIALGROUP_TRANSPARENCY
	{
		COLOR	MATERIAL_TRANSPARENCY_COLOR { OPEN; }
		REAL 	MATERIAL_TRANSPARENCY_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		REAL  MATERIAL_TRANSPARENCY_REFRACTION { MIN 0.25; MAX 4.0; STEP 0.01; }
		BOOL  MATERIAL_TRANSPARENCY_FRESNEL { }
		BOOL  MATERIAL_TRANSPARENCY_ADDITIVE { }
		SEPARATOR { }
		TEXGROUP MATERIAL_TRANSPARENCY_TEXGROUP { }
		LONG MATERIAL_TRANSPARENCY_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_TRANSPARENCY_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR { }

		REAL  MATERIAL_TRANSPARENCY_DISPERSION { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		LONG  MATERIAL_TRANSPARENCY_MINSAMPLES { PARENTID MATERIAL_TRANSPARENCY_DISPERSION; MIN 1; MAX 10000; }
		LONG  MATERIAL_TRANSPARENCY_MAXSAMPLES { PARENTID MATERIAL_TRANSPARENCY_DISPERSION; MIN 1; MAX 10000; }
		REAL  MATERIAL_TRANSPARENCY_ACCURACY   { PARENTID MATERIAL_TRANSPARENCY_DISPERSION; UNIT PERCENT; MIN 0.0; MAX 100.0; }
	}

	GROUP ID_MATERIALGROUP_REFLECTION
	{
		COLOR	MATERIAL_REFLECTION_COLOR { OPEN; }
		REAL 	MATERIAL_REFLECTION_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		SEPARATOR { }
		TEXGROUP MATERIAL_REFLECTION_TEXGROUP { }
		LONG MATERIAL_REFLECTION_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_REFLECTION_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR { }

		REAL  MATERIAL_REFLECTION_DISPERSION { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		LONG  MATERIAL_REFLECTION_MINSAMPLES { PARENTID MATERIAL_REFLECTION_DISPERSION; MIN 1; MAX 10000; }
		LONG  MATERIAL_REFLECTION_MAXSAMPLES { PARENTID MATERIAL_REFLECTION_DISPERSION; MIN 1; MAX 10000; }
		REAL  MATERIAL_REFLECTION_ACCURACY   { PARENTID MATERIAL_REFLECTION_DISPERSION; UNIT PERCENT; MIN 0.0; MAX 100.0; }
	}

	GROUP ID_MATERIALGROUP_ENVIRONMENT
	{
		COLOR MATERIAL_ENVIRONMENT_COLOR { OPEN; }
		REAL MATERIAL_ENVIRONMENT_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		SEPARATOR { }
		TEXGROUP MATERIAL_ENVIRONMENT_TEXGROUP { }
		LONG MATERIAL_ENVIRONMENT_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_ENVIRONMENT_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		SEPARATOR { }
		REAL MATERIAL_ENVIRONMENT_TILESX { MIN 0.0; STEP 0.01; }
		REAL MATERIAL_ENVIRONMENT_TILESY { MIN 0.0; STEP 0.01; }
		BOOL MATERIAL_ENVIRONMENT_EXCLUSIVE { }
	}

	GROUP ID_MATERIALGROUP_FOG
	{
		COLOR MATERIAL_FOG_COLOR	{ OPEN; }
		REAL MATERIAL_FOG_BRIGHTNESS	{ UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		REAL MATERIAL_FOG_DISTANCE	{ UNIT METER; MIN 0.0; }
	}

	GROUP ID_MATERIALGROUP_BUMP
	{
		REAL MATERIAL_BUMP_STRENGTH { UNIT PERCENT; MIN -1000000.0; MAX 1000000.0; MINSLIDER -100.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;   }
		BOOL MATERIAL_BUMP_MIPFALLOFF	{ }
		SEPARATOR { }
		TEXGROUP MATERIAL_BUMP_TEXGROUP { }
	}

	GROUP ID_MATERIALGROUP_ALPHA
	{
		COLOR MATERIAL_ALPHA_COLOR { }
		COLOR MATERIAL_ALPHA_DELTA { }
		BOOL MATERIAL_ALPHA_INVERT { }
		BOOL MATERIAL_ALPHA_SOFT { }
		BOOL MATERIAL_ALPHA_IMAGEALPHA { }
		BOOL MATERIAL_ALPHA_PREMULTIPLIED	{ }
		SEPARATOR { }
		TEXGROUP MATERIAL_ALPHA_TEXGROUP { }
	}

	GROUP ID_MATERIALGROUP_SPECULAR
	{
		LAYOUTGROUP; COLUMNS 2;
		GROUP
		{
			LONG MATERIAL_SPECULAR_MODE	{ CYCLE { MATERIAL_SPECULAR_MODE_PLASTIC; MATERIAL_SPECULAR_MODE_METAL; MATERIAL_SPECULAR_MODE_COLORED; } }
			REAL MATERIAL_SPECULAR_WIDTH { UNIT PERCENT; MIN 0.0; MAX 100.0; }
			REAL MATERIAL_SPECULAR_HEIGHT { UNIT PERCENT; MIN 0.0; MAX 1000.0; }
			REAL MATERIAL_SPECULAR_FALLOFF { UNIT PERCENT; MIN -100.0; MAX 100.0; }
			REAL MATERIAL_SPECULAR_INNERWIDTH { UNIT PERCENT; MIN 0.0; MAX 100.0; }
		}
		GROUP
		{
			BITMAPBUTTON MATERIAL_SPECULARPREVIEW { BORDER; }
		}
	}

	GROUP ID_MATERIALGROUP_SPECULARCOLOR
	{
		COLOR MATERIAL_SPECULAR_COLOR { OPEN; }
		REAL MATERIAL_SPECULAR_BRIGHTNESS	{ UNIT PERCENT; MIN 0.0; MAX 10000.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		SEPARATOR { }
		TEXGROUP MATERIAL_SPECULAR_TEXGROUP { }
		LONG MATERIAL_SPECULAR_TEXTUREMIXING { CYCLE { MATERIAL_TEXTUREMIXING_NORMAL; MATERIAL_TEXTUREMIXING_ADD; MATERIAL_TEXTUREMIXING_SUBTRACT; MATERIAL_TEXTUREMIXING_MULTIPLY; } }
		REAL MATERIAL_SPECULAR_TEXTURESTRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
	}

	GROUP ID_MATERIALGROUP_GLOW
	{
		COLOR MATERIAL_GLOW_COLOR	{ }
		REAL MATERIAL_GLOW_BRIGHTNESS	{ UNIT PERCENT; MIN 0.0; MAX 100.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		REAL MATERIAL_GLOW_INNERSTRENGTH { UNIT PERCENT; MIN 0.0; MAX 10000.0; }
		REAL MATERIAL_GLOW_OUTERSTRENGTH { UNIT PERCENT; MIN 0.0; MAX 10000.0; }
		REAL MATERIAL_GLOW_RADIUS { UNIT METER; MIN 0.0; }
		REAL MATERIAL_GLOW_RANDOM	{ UNIT PERCENT; MIN 0.0; MAX 100.0; }
		REAL MATERIAL_GLOW_FREQUENCY { MIN 0.0; STEP 0.01; }
		BOOL MATERIAL_GLOW_USEMATERIALCOLOR { }
	}

	GROUP ID_MATERIALGROUP_DISPLACEMENT
	{
		REAL MATERIAL_DISPLACEMENT_STRENGTH	{ UNIT PERCENT; MIN -100.0; MAX 100.0;  CUSTOMGUI REALSLIDER;  }
		REAL MATERIAL_DISPLACEMENT_HEIGHT { UNIT METER; }
		SEPARATOR { }
		TEXGROUP MATERIAL_DISPLACEMENT_TEXGROUP { }
	}

	INCLUDE Millum;

	GROUP ID_MATERIALGROUP_ILLUMINATION
	{
		SEPARATOR { }

		LONG MATERIAL_ILLUMINATION_MODEL { CYCLE { MATERIAL_ILLUMINATION_MODEL_PHONG; MATERIAL_ILLUMINATION_MODEL_BLINN; MATERIAL_ILLUMINATION_MODEL_ORENNAYAR; } }
		REAL MATERIAL_ILLUMINATION_DIFFUSEFALLOFF	{ UNIT PERCENT; MIN -1000.0; MAX 1000.0; }
		REAL MATERIAL_ILLUMINATION_DIFFUSELEVEL	{ UNIT PERCENT; MIN 0.0; MAX 1000.0; }
		REAL MATERIAL_ILLUMINATION_ROUGHNESS { UNIT PERCENT; MIN 0.0; MAX 200.0; }
	}
	INCLUDE Mbase;
}
